import java.util.ArrayList;

public class SampleAndHoldEventProcessor extends DrawObjectEventProcessor
{
	@Override
	public void TryProcessUserKeyboardAction(MainWindow.GUIElements GUIElements, KeyEventProcessor KeyEventProcessor, MouseEventProcessor MouseEventProcessor, ObjectStorage ObjectStorage, IOProgram IOProgram)
	{
		if (!(KeyboardEventsToBeProcessed(GUIElements)))
			return;

		// ****************************************************************
		// n (increase SampleAndHold Strength by a fixed amount)
		if (KeyEventProcessor.IsKeyTyped('n'))
		{
			if (MultiSelectionExisting)
			{
				ArrayList<DrawObject> MultiSelectionObjects = ObjectStorage.GetMultiSelectionObjects();

				for (int m = 0; m < MultiSelectionObjects.size(); m++)
				{
					DrawObject o = MultiSelectionObjects.get(m);
					if (o.IsSampleAndHold())
					{
						((SampleAndHold) o).ToggleIsNegative();
					}
				}

				GUIElements.GetMainWindow().DoRedraw();
			}
			else if (DEFINED(NearObject))
			{
				if (NearObject.IsSampleAndHold())
				{
					((SampleAndHold) NearObject).ToggleIsNegative();

					GUIElements.GetMainWindow().DoRedraw();
				}
			}
		}

		return;
	}

	@Override
	public void TryProcessUserMouseAction(MainWindow.GUIElements GUIElements, KeyEventProcessor KeyEventProcessor, MouseEventProcessor MouseEventProcessor, ObjectStorage ObjectStorage, IOProgram IOProgram)
	{
		if (!(MouseEventsToBeProcessed(GUIElements)))
			return;

		// ****************************************************************
		if (MouseEventProcessor.IsRightButtonClicked())
		{
			if (DEFINED(SingleSelectedObject))
			{
				if (SingleSelectedObject.IsSampleAndHold())
				{
					((SampleAndHold) SingleSelectedObject).Toggle();

					GUIElements.GetMainWindow().DoRedraw();
				}
			}
		}

		return;
	}
}
